/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package Chapter10.start;

import java.time.*;
import static java.time.Month.*;
import static java.time.temporal.ChronoUnit.HOURS;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class DataSource {
    public Person[] people=new Person[3];
    public Meeting[] meetings=new Meeting[4];
    
    public DataSource(){

        //Populate the data source.  We will do this explicity
        //but we could equally create the instances from a database or file.
        
        //Create people.
        Person me = new Person("Employee", "matthew", "gregory", Year.of(1971).atMonth(JULY).atDay(28));
        me.timezone = ZoneId.of("Australia/Sydney");
        Person myCustomer = new Person("Customer", "John", "Smith", LocalDate.now().withYear(1998));
        myCustomer.timezone = ZoneId.of("America/New_York");
        Person myColleague = new Person("Employee", "Penny", "Chan", LocalDate.now().withYear(1976));
        myColleague.timezone = ZoneId.of("Australia/Perth");
        
        //Add them to our array
        people[0]=me;
        people[1]=myCustomer;
        people[2]=myColleague;

        //Create meetings
        Meeting myMeeting = new Meeting(me);
        Meeting initialMeeting = new Meeting(me,myCustomer);
        Meeting internalMeeting = new Meeting(me,myColleague);
        Meeting followupMeeting = new Meeting(me,myColleague,myCustomer);
        
        //Add them to our array
        meetings[0]=myMeeting;
        meetings[1]=initialMeeting;
        meetings[2]=internalMeeting;
        meetings[3]=followupMeeting;
    }    

}
